import sqlite3
from pathlib import Path

DB_PATH = Path(__file__).parent / 'rockgmer.db'

def get_connection():
    return sqlite3.connect(DB_PATH)

def init_db():
    conn = get_connection()
    cur = conn.cursor()

    cur.execute('''
    CREATE TABLE IF NOT EXISTS settings (
        key TEXT PRIMARY KEY,
        value TEXT
    )
    ''')

    cur.execute('''
    CREATE TABLE IF NOT EXISTS proveedores (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        nombre TEXT NOT NULL,
        contacto TEXT,
        notas TEXT
    )
    ''')

    cur.execute('''
    CREATE TABLE IF NOT EXISTS articulos (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        codigo TEXT,
        game TEXT,
        descripcion TEXT,
        precio REAL,
        margen_unitario REAL,
        activo INTEGER DEFAULT 1
    )
    ''')

    cur.execute('''
    CREATE TABLE IF NOT EXISTS ventas (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        fecha TEXT,
        consecutivo INTEGER UNIQUE,
        proveedor_id INTEGER,
        articulo_id INTEGER,
        cantidad INTEGER,
        precio_unitario REAL,
        monto_total REAL,
        margen_total REAL,
        anulada INTEGER DEFAULT 0,
        created_at TEXT DEFAULT CURRENT_TIMESTAMP
    )
    ''')

    conn.commit()
    conn.close()
